#!/bin/sh

prefix=/usr
exec_prefix=/usr
datarootdir=${prefix}/share

#check for /etc/enigma2 folder
if [ ! -d /etc/enigma2 ] ; then
	mkdir -p /etc/enigma2
fi

# workaround for corrupt ssl files
if [ "$(grep -i config.misc.firstrun=true /etc/enigma2/settings)" != "" ]; then
	rm -rf /etc/enigma2/cert.pem &
	rm -rf /etc/enigma2/key.pem &
fi

#ciplushelper start delay
if [ -e /usr/bin/ciplushelper ]; then
    sleep 3
fi

if [ -e /proc/stb/info/boxtype ]; then
	stbcheck=`cat /proc/stb/info/boxtype`
	if [ $stbcheck == "sf8008" ] || [ $stbcheck == "sf8008m" ] || [ $stbcheck == "sf8008opt" ] || [ $stbcheck == "sx988" ] || [ $stbcheck == "ip8" ] || [ $stbcheck == "ustym4kpro" ] || [ $stbcheck == "ustym4kottpremium" ] || [ $stbcheck == "ustym4ks2ottx" ] || [ $stbcheck == "cc1" ] || [ $stbcheck == "trio4k" ] || [ $stbcheck == "gbip4k" ] || [ $stbcheck == "gbmv200" ] || [ $stbcheck == "beyonwizv2" ] || [ $stbcheck == "viper4k" ] || [ $stbcheck == "og2ott4k" ] || [ $stbcheck == "sfx6008" ] || [ $stbcheck == "sx88v2" ]; then
		count=`ps -ef |grep libreader |grep -v "grep" |wc -l`
		if [ 0 == $count ];then
			libreader 720P_50
		fi
	fi
fi
# Show backdrop on enigma2 start.
if [ -x "/usr/bin/showiframe" ]; then
	if [ -e /proc/stb/info/boxtype ]; then
		stbcheck=`cat /proc/stb/info/boxtype | cut -c1-2`
		if [ ! $stbcheck == "u5" ] && [ ! $stbcheck == "u4" ]; then
			killall -9 showiframe; sleep 1
		fi
	else
		killall -9 showiframe; sleep 1
	fi
	SKIN=`sed -En 's|^config\.skin\.primary_skin=(.+)/skin\.xml$|\1|p' "/etc/enigma2/settings"`
	if [ -n "${SKIN}" ]; then
		SEARCHDIRS="/etc/enigma2/$SKIN /etc/enigma2/skin_common /etc/enigma2 /usr/share/enigma2/$SKIN /usr/share/enigma2/skin_default /usr/share/enigma2 /usr/share"
	else
		SEARCHDIRS="/etc/enigma2/skin_common /etc/enigma2 /usr/share/enigma2/skin_default /usr/share/enigma2 /usr/share"
	fi
	for DIR in $SEARCHDIRS; do
		if [ -d "${DIR}" ] && [ -f "${DIR}/backdrop.mvi" ]; then
			"/usr/bin/showiframe" "${DIR}/backdrop.mvi"
			break
		fi
	done
fi

######### Some EGAMI Scripts

[ ! -d /picon ] && mkdir /picon && touch /picon/picon.png
[ ! -d /usr/tuxbox/config  ] && mkdir -p /usr/tuxbox/config
[ ! -e /usr/bin/egami_modules.sh ] && touch /usr/bin/egami_modules.sh && chmod 755 /usr/bin/egami_modules.sh
[ -e /usr/bin/egami_modules.sh ] && /usr/bin/egami_modules.sh

tar xzf /etc/var.tar.gz -C /

######### END OF EGAMI Scripts

# hook to execute scripts always before enigma2 start
if [ -x /usr/bin/enigma2_pre_start.sh ]; then
	/usr/bin/enigma2_pre_start.sh
fi

if [ -e /proc/stb/info/hwmodel ]; then
	 stbcheck=`cat /proc/stb/info/hwmodel | cut -c1-8`
	 if [ $stbcheck == "optimuss" ]; then
			string=`mount | grep 'sda1' | cut -d " " -f3`
			if [ -e $string/sat-soft/settings.sh ]; then
				 chmod 755 $string/sat-soft/settings.sh
				 $string/sat-soft/settings.sh
			fi
	 fi
fi

if [ -d /home/root ]; then
	cd /home/root
	export HOME=/home/root
fi

# any debuglevel passed?
if [ -z $ENIGMA_DEBUG_LVL ]; then
	DEBUG_LVL=3
else
	DEBUG_LVL=$ENIGMA_DEBUG_LVL
fi

#check for sundtek tuner helper lib
if [ -e /opt/lib/libmediaclient.so ]; then
	LIBS="/opt/lib/libmediaclient.so /usr/lib/libopen.so.0.0.0"
else
	LIBS="/usr/lib/libopen.so.0.0.0"
fi

#check for specific pagecache helper lib
if [ -e /usr/lib/libpagecache.so ]; then
	LIBS="$LIBS /usr/lib/libpagecache.so"
fi

if [ -f /proc/stb/fp/nec_ir ]; then
	/sbin/insmod /lib/modules/4.9/extra/lcd/lcd.ko
	echo 1 > /proc/stb/fp/nec_ir
	[ -f /sys/class/remote/amremote/protocol ] && echo 2 > /sys/class/remote/amremote/protocol
fi

#check for receiver specific passthrough helper lib
#if [ -e /usr/lib/libpassthrough.so ]; then
#	LIBS="$LIBS /usr/lib/libpassthrough.so"
#fi

if [ ! -e /etc/enigma2/settings ]; then
	touch /etc/enigma2/settings
fi

#check for default sat settings
stbcheck=00
if [ -e /proc/stb/info/subtype ]; then
	 stbcheck=`cat /proc/stb/info/subtype`
fi
if [ -e /proc/stb/info/boxtype ] && [ -e /proc/stb/info/chipset ]; then
	 boxtype=`cat /proc/stb/info/boxtype`
	 chipset=`cat /proc/stb/info/chipset`
	 if  [ $boxtype == "et7000" ] && [ $chipset == "bcm73625" ]; then
			 stbcheck=01
	 fi
fi

sync

# in case sysctl.conf is not properly loaded - load sysctl.conf here again...
sysctl -p

(sleep 2; echo "enigma2 is the main pvr application... adjust oom score!"; PID=$(pidof enigma2); \
				[ -e /proc/$PID/oom_score_adj ] && echo "-999" > /proc/$PID/oom_score_adj || echo "-17" > /proc/$PID/oom_adj;) &

export LC_CTYPE="en_US.UTF-8"

# Randomize timestamp if clock is not set
RANDOMIZE1970=''
time=`date +%Y` ;
if [ "$time" = 1970 ]; then
	RANDOMIZE1970="$(strings /dev/urandom | grep -o '[[:alnum:]]' | head -n 5 | tr -d '\n')"
fi

# Set time format used to prefix each line in the debug logs.
DEBUGTIME=`sed -En 's|^config\.crash\.debugTimeFormat=(.+)$|\1|p' "/etc/enigma2/settings"`
[ -n "${DEBUGTIME}" ] || DEBUGTIME="2"
DEBUG_TIME="${DEBUGTIME}"

# Create and set log folder
LOGFOLDER="/home/root/logs/"
if [ ! -d $LOGFOLDER ] ; then mkdir -p $LOGFOLDER; fi
if [ "$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')" != "" -a -d "$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')" ]; then
	LOGFOLDER=$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')
fi

# Enable and configure gstreamer debug log of category and level without color
if [ "$(grep -i config.crash.gstdebug=true /etc/enigma2/settings)" != "" ]; then
	GSTDEBUGCATEGORY="*"
	GSTDEBUGLEVEL="INFO"
	if [ "$(grep config.crash.gstdebugcategory= /etc/enigma2/settings | sed 's/config.crash.gstdebugcategory=//g')" != "" ]; then
		GSTDEBUGCATEGORY=$(grep config.crash.gstdebugcategory= /etc/enigma2/settings | sed 's/config.crash.gstdebugcategory=//g')
	fi
	if [ "$(grep config.crash.gstdebuglevel= /etc/enigma2/settings | sed 's/config.crash.gstdebuglevel=//g')" != "" ]; then
		GSTDEBUGLEVEL=$(grep config.crash.gstdebuglevel= /etc/enigma2/settings | sed 's/config.crash.gstdebuglevel=//g')
	fi
	export GST_DEBUG_FILE="${LOGFOLDER}$(date +%Y%m%d-%H%M%S)-gstreamer-debug.log"
	export GST_DEBUG="${GSTDEBUGCATEGORY}:${GSTDEBUGLEVEL}"
	export GST_DEBUG_NO_COLOR="1"
fi

# Enable and set gstreamer directory for pipeline graphs that are not created if directory is not set
if [ "$(grep -i config.crash.gstdot=true /etc/enigma2/settings)" != "" ]; then
	export GST_DEBUG_DUMP_DOT_DIR=${LOGFOLDER}
fi

# Enable generation of core dumps
# It would be best to have this at system startup because this way we may not
# catch core dumps that happen early to enigma2.
# The kernel.core_pattern could be set via /etc/sysctl.conf.
# The size limit could be set via /etc/security/limits.conf.
if [ "$(grep -i config.crash.coredump=true /etc/enigma2/settings)" != "" ]; then
	COREDUMPSIZE=$((10 * 512 * 4 - 1 * 512 * 4)) # size is in blocks (512 byte) so this sets 10 MB - 1 MB for log files
	COREDUMPFILE=${LOGFOLDER}%t-enigma2-core.dump
	if [ "$(grep -i config.crash.sizeloglimit= /etc/enigma2/settings | sed 's/config.crash.sizeloglimit=//g')" != "" ]; then
		COREDUMPSIZE=$(grep -i config.crash.sizeloglimit= /etc/enigma2/settings | sed 's/config.crash.sizeloglimit=//g')
		COREDUMPSIZE=$((${COREDUMPSIZE} * 512 * 4 - 1 * 512 * 4))
	fi
	echo ${COREDUMPFILE} > /proc/sys/kernel/core_pattern
	ulimit -c ${COREDUMPSIZE}
fi

# Start enigma2 with or without debug
if [ "$(grep -i config.crash.enabledebug=true /etc/enigma2/settings)" != "" ]; then
	DEBUG_LVL='4'
	(LD_PRELOAD=$LIBS ENIGMA_DEBUG_LVL=$DEBUG_LVL ENIGMA_DEBUG_TIME="${DEBUG_TIME}" /usr/bin/enigma2 &> ${LOGFOLDER}$(date +%Y%m%d-%H%M%S)-enigma2-debug.log) &
else
	(LD_PRELOAD=$LIBS ENIGMA_DEBUG_LVL=$DEBUG_LVL ENIGMA_DEBUG_TIME="${DEBUG_TIME}" /usr/bin/enigma2) &
fi

enigma2pid=$!

# Enable generation of core dumps with ELF header included.
# This seem to be required by gdb.
# Would be default if kernel is configured with CONFIG_CORE_DUMP_DEFAULT_ELF_HEADERS.
# Default coredump filter can only be set via kernel command line.
# In all other cases this is only available per process.
if [ "$(grep -i config.crash.coredump=true /etc/enigma2/settings)" != "" ]; then
	COREDUMPFILTER=0x33
	echo ${COREDUMPFILTER} > /proc/${enigma2pid}/coredump_filter
fi

wait ${enigma2pid}

# enigma2 exit codes:
#
# 1 - halt
# 2 - reboot
# 3 - restart enigma
#
# >128 signal

ret=$?

function check_busybox_update {
	if [ -e /etc/enigma2/.busybox_update_required ]; then
		rm /etc/enigma2/.busybox_update_required
		opkg install busybox --force-reinstall
	fi
}

if [ "$ret" -ne "1" ]; then
	if [ -e /proc/stb/info/boxtype ]; then
		stbcheck=`cat /proc/stb/info/boxtype | cut -c1-2`
		if [ $stbcheck == "u5" ] || [ $stbcheck == "u4" ]; then
			killall -9 showiframe; sleep 5
		fi
		stbcheck=`cat /proc/stb/info/boxtype`
		if [ $stbcheck == "sf8008" ] || [ $stbcheck == "sf8008m" ] || [ $stbcheck == "sf8008opt" ] || [ $stbcheck == "sx988" ] || [ $stbcheck == "ip8" ] || [ $stbcheck == "ustym4kpro" ] || [ $stbcheck == "ustym4kottpremium" ] || [ $stbcheck == "ustym4ks2ottx" ] || [ $stbcheck == "cc1" ] || [ $stbcheck == "trio4k" ] || [ $stbcheck == "gbip4k" ] || [ $stbcheck == "gbmv200" ] || [ $stbcheck == "beyonwizv2" ] || [ $stbcheck == "viper4k" ] || [ $stbcheck == "og2ott4k" ] || [ $stbcheck == "sfx6008" ] || [ $stbcheck == "sx88v2" ]; then
			killall -9 libreader; sleep 5
		fi
	fi
fi

case $ret in
	1)
		check_busybox_update
		touch /etc/enigma2/.deep
		/sbin/halt
		;;
	2)
		check_busybox_update
		if [ -f /proc/stb/fp/force_restart ]; then
			echo 1 > /proc/stb/fp/force_restart
		fi
		[[ -e /etc/enigma2/.deep ]] && rm /etc/enigma2/.deep
		/sbin/reboot
		;;
	3)
		rm -fR /home/root/.gstreamer-0.10
		rm -f /tmp/.listen.camd.socket.ignore
		;;
	4)
		check_busybox_update
		/sbin/rmmod lcd
		/usr/sbin/fpupgrade --upgrade 2>&1 | tee /home/root/fpupgrade.log
		sleep 1;
		/sbin/rmmod fp
		/sbin/modprobe fp
		[[ -e /etc/enigma2/.deep ]] && rm /etc/enigma2/.deep
		/sbin/reboot
		;;
	16)
		if [ -e /proc/stb/info/model ]; then
			stbcheck=`cat /proc/stb/info/model`
			if [[ $stbcheck == "one" || $stbcheck == "two" ]]; then
				/usr/sbin/to-the-rescue
			fi
		fi
		if [ -e /dev/block/by-name/flag ]; then
			echo -n "0" > /dev/block/by-name/flag
		elif [ -e /dev/block/by-name/bootoptions ]; then
			mkdir -p /tmp/bootoptions
			mount /dev/block/by-name/bootoptions /tmp/bootoptions
			cp -f /tmp/bootoptions/STARTUP_RECOVERY /tmp/bootoptions/STARTUP_ONCE
		else
			echo "rescue" > /proc/stb/fp/boot_mode
		fi
		[[ -e /etc/enigma2/.deep ]] && rm /etc/enigma2/.deep
		/sbin/reboot
		;;
	43)
		init 1
		;;
	44)
		# little hack but it will be fixed soon in drivers
		/usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/bin/fbclear
		/usr/bin/showiframe /usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/wait.mvi
		echo fpupload >/proc/vfd && sleep 3 && dd bs=256k if=/tmp/micom.bin of=/dev/mcu
		/usr/bin/showiframe /usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/reboot.mvi
		[[ -e /etc/enigma2/.deep ]] && rm /etc/enigma2/.deep
		# Wait forever for the user to power off
		while(true) ; do sleep 60 ; done
		;;
	45)
		echo "    " > /dev/lcd0
		/usr/bin/gigablue_wol
		;;
	*)
		rm -f /tmp/.listen.camd.socket.ignore
		;;
esac
