# -*- coding: utf-8 -*-
from __future__ import absolute_import
from __future__ import print_function
from enigma import getDesktop

from Screens.Screen import Screen
from Screens.Console import Console
from Screens.MessageBox import MessageBox
from Screens.ChoiceBox import ChoiceBox
from Screens.VirtualKeyBoard import VirtualKeyBoard
from Components.Button import Button
from Components.ActionMap import ActionMap, NumberActionMap
from Components.MenuList import MenuList
from Components.Input import Input
from Components.Label import Label
from Components.ProgressBar import ProgressBar
from Components.Pixmap import Pixmap, MultiPixmap
from Components.config import *
from Components.ConfigList import ConfigListScreen
import Components.Harddisk
from Tools.LoadPixmap import LoadPixmap
from Tools.Directories import fileExists
import os
from skin import parseColor
#from boxbranding import getImageDistro

EGAMIBootImageChoose_Skin = '\n\t\t<screen name="EGAMIBootMini" position="center,center" size="902,380" title="EGAMIBoot - Menu" >\n\t\t\t<widget name="label2" position="145,10" size="440,30" zPosition="1" font="Regular;20" backgroundColor="#9f1313" transparent="1"/>\n\t\t\t<widget name="label3" position="145,35" size="440,30" zPosition="1" font="Regular;20" backgroundColor="#9f1313" transparent="1"/>\n\t\t\t<widget name="label4" position="145,60" size="440,30" zPosition="1" font="Regular;20" backgroundColor="#9f1313" transparent="1"/>\n\t\t\t<widget name="label5" position="145,85" size="440,30" zPosition="1" font="Regular;20" backgroundColor="#9f1313" transparent="1"/>\n\t\t\t<widget name="label6" position="420,10" size="440,30" zPosition="1" halign="right" font="Regular;20" backgroundColor="#9f1313" foregroundColor="#00389416" transparent="1"/>\n\t\t\t<widget name="label7" position="420,35" size="440,30" zPosition="1" halign="right" font="Regular;20" backgroundColor="#9f1313" foregroundColor="#00389416" transparent="1"/>\n\t\t\t<widget name="label8" position="420,60" size="440,30" zPosition="1" halign="right" font="Regular;20" backgroundColor="#9f1313" foregroundColor="#00389416" transparent="1"/>\n\t\t\t<widget name="label9" position="420,85" size="440,30" zPosition="1" halign="right" font="Regular;20" backgroundColor="#9f1313" foregroundColor="#00389416" transparent="1"/>\n\t\t\t<widget name="label10" position="145,110" size="440,30" zPosition="1" font="Regular;20" backgroundColor="#9f1313" transparent="1"/>\n\t\t\t<widget name="label11" position="420,110" size="440,30" zPosition="1" halign="right" font="Regular;20" backgroundColor="#9f1313" foregroundColor="#00389416" transparent="1"/>\n\t\t\t<widget name="label1" position="25,145" size="840,22" zPosition="1" halign="center" font="Regular;18" backgroundColor="#9f1313" transparent="1"/>\n\t\t\t<widget name="device_icon" position="25,20" size="80,80" alphatest="on" />\n\t\t\t<widget name="free_space_progressbar" position="265,42" size="500,13" borderWidth="1" zPosition="3" />\n\t\t\t<widget name="config" position="25,180" size="840,150" scrollbarMode="showOnDemand"/>\n\t\t\t<ePixmap pixmap="skin_default/buttons/red-big.png" position="350,340" size="180,40" alphatest="on" />\n\t\t\t<widget name="key_red" position="345,340" zPosition="1" size="170,40" font="Regular;20" halign="center" valign="center" backgroundColor="#9f1313" transparent="1" />\n\t\t</screen>'

def Freespace(dev):
	statdev = os.statvfs(dev)
	space = (statdev.f_bavail * statdev.f_frsize) / 1024
	print("[EGAMIBoot] Free space on %s = %i kilobytes" %(dev, space))
	return space

class EGAMIBootImageChoose(Screen):
	def __init__(self, session):
		self.skin = EGAMIBootImageChoose_Skin
		Screen.__init__(self, session)
		self.list = []
		self.setTitle('EGAMIBoot - Menu')
		self['device_icon'] = Pixmap()
		self['free_space_progressbar'] = ProgressBar()
		self['linea'] = ProgressBar()
		self['config'] = MenuList(self.list)
		self['key_red'] = Label(_('Boot Image(Ok)'))
	#        self['key_yellow'] = Label(_('Remove Image '))
	#        self['key_blue'] = Label(_('Advanced'))
		self['label2'] = Label(_('EGAMIBoot is running from:'))
		self['label3'] = Label(_('Used:'))
		self['label4'] = Label(_('Available:'))
		self['label5'] = Label(_('EGAMIBoot is running image:'))
		self['label6'] = Label('')
		self['label7'] = Label('')
		self['label8'] = Label('')
		self['label9'] = Label('')
		self['label10'] = Label(_('Number of installed images in EGAMIBoot:'))
		self['label11'] = Label('')
		self['label1'] = Label(_('Here is the list of installed images in Your STB. Please choose an image to boot.'))
		self['actions'] = ActionMap(['WizardActions', 'ColorActions'], {'red': self.boot,
		'ok': self.boot,
		'back': self.close})
		self.onShow.append(self.updateList)

	def updateList(self):
		self.list = []
		try:
			pluginpath = '/usr/lib/enigma2/python/Plugins/Extensions/EGAMIBoot'
			f = open(pluginpath + '/.egamiboot_location', 'r')
			mypath = f.readline().strip()
			f.close()
		except:
			mypath = '/media/hdd'

		icon = 'dev_usb.png'
		if 'card' in mypath or 'sd' in mypath:
			icon = 'dev_sd.png'
		elif 'hdd' in mypath:
			icon = 'dev_hdd.png'
		elif 'cf' in mypath:
			icon = 'dev_cf.png'
		icon = pluginpath + '/images/' + icon
		png = LoadPixmap(icon)
		self['device_icon'].instance.setPixmap(png)
		device = '/media/egamiboot'
		dev_free = dev_free_space = def_free_space_percent = ''
		rc = os.system('df > /tmp/ninfo.tmp')
		if fileExists('/tmp/ninfo.tmp'):
			f = open('/tmp/ninfo.tmp', 'r')
			for line in f.readlines():
				line = line.replace('part1', ' ')
				parts = line.strip().split()
				totsp = len(parts) - 1
				if parts[totsp] == device:
					if totsp == 5:
						dev_free = parts[1]
						dev_free_space = parts[3]
						def_free_space_percent = parts[4]
					else:
						dev_free = 'N/A   '
						dev_free_space = parts[2]
						def_free_space_percent = parts[3]
					break

			f.close()
			os.remove('/tmp/ninfo.tmp')
		self.availablespace = dev_free_space[0:-3]
		perc = int(def_free_space_percent[:-1])
		self['free_space_progressbar'].setValue(perc)
		green = '#00389416'
		red = '#00ff2525'
		yellow = '#00ffe875'
		orange = '#00ff7f50'
		if perc < 30:
			color = green
		elif perc < 60:
			color = yellow
		elif perc < 80:
			color = orange
		else:
			color = red
		self['label6'].instance.setForegroundColor(parseColor(color))
		self['label7'].instance.setForegroundColor(parseColor(color))
		self['label8'].instance.setForegroundColor(parseColor(color))
		self['label9'].instance.setForegroundColor(parseColor(color))
		self['label11'].instance.setForegroundColor(parseColor(color))
	#        self['free_space_progressbar'].instance.setForegroundColor(parseColor(color))
		try:
			f2 = open('/media/egamiboot/EgamiBootI/.egamiboot', 'r')
			mypath2 = f2.readline().strip()
			f2.close()
		except:
			mypath2 = 'Flash'

		if mypath2 == 'Flash':
#			image = getImageDistro()
			image = os.popen("head -n 1 /etc/hostname").read().split()[0]
			if fileExists('/etc/image-version'):
				if 'build' not in image:
					f = open('/etc/image-version', 'r')
					for line in f.readlines():
						if 'build=' in line:
							image = image + ' build ' + line[6:-1]
							open('/media/egamiboot/EgamiBootI/.Flash', 'w').write(image)
							break
					f.close()
		elif fileExists('/media/egamiboot/EgamiBootI/.Flash'):
			f = open('/media/egamiboot/EgamiBootI/.Flash', 'r')
			image = f.readline().strip()
			f.close()
		image = ' [' + image + ']'
		self.list.append('Flash' + image)
		self['label6'].setText(mypath)
		self['label7'].setText(def_free_space_percent)
		self['label8'].setText(dev_free_space[0:-3] + ' MB')
		self['label9'].setText(mypath2)
		mypath = '/media/egamiboot/EgamiBootI/'
		myimages = os.listdir(mypath)
		for fil in myimages:
			if os.path.isdir(os.path.join(mypath, fil)):
				self.list.append(fil)

		self['label11'].setText(str(len(self.list) - 1))
		self['config'].setList(self.list)

	def myclose(self):
		self.close()

	def myclose2(self, message):
		self.session.open(MessageBox, message, MessageBox.TYPE_INFO)
		self.close()

	def boot(self):
		self.mysel = self['config'].getCurrent()
		if self.mysel:
			out = open('/media/egamiboot/EgamiBootI/.egamiboot', 'w')
			out.write(self.mysel)
			out.close()
			os.system('rm /tmp/.egamireboot')
			message = _('Are you sure you want to Boot Image:\n') + self.mysel + ' ?'
			ybox = self.session.openWithCallback(self.boot2, MessageBox, message, MessageBox.TYPE_YESNO)
			ybox.setTitle(_('Boot Confirmation'))
		else:
			self.mysel

	def boot2(self, yesno):
		if yesno:
			os.system('touch /tmp/.egamireboot')
			os.system('reboot -f')
		else:
			os.system('touch /tmp/.egamireboot')
			self.close()

def main(session, **kwargs):
	try:
		f = open('/usr/lib/enigma2/python/Plugins/Extensions/EGAMIBoot/.egamiboot_location', 'r')
		mypath = f.readline().strip()
		f.close()
		if not fileExists('/media/egamiboot'):
			os.mkdir('/media/egamiboot')
		cmd = 'mount ' + mypath + ' /media/egamiboot'
		os.system(cmd)
		f = open('/proc/mounts', 'r')
		for line in f.readlines():
			if line.find('/media/egamiboot') != -1:
				line = line[0:9]
				break

		cmd = 'mount ' + line + ' ' + mypath
		os.system(cmd)
		cmd = 'mount ' + mypath + ' /media/egamiboot'
		os.system(cmd)
	except:
		pass

	if fileExists('/media/egamiboot'):
		if fileExists('/media/egamiboot/EgamiBootI/.egamiboot'):
			session.open(EGAMIBootImageChoose)

def menu(menuid, **kwargs):
	if menuid == "mainmenu":
		return [(_("EGAMI MultiBoot"), main, "egami_boot", 1)]
	return []

from Plugins.Plugin import PluginDescriptor

def Plugins(**kwargs):
	screenwidth = getDesktop(0).size().width()
	if screenwidth and screenwidth == 1920:  
		return [
			PluginDescriptor(name = "EGAMIBoot", description = "EGAMI MultiBoot", where = PluginDescriptor.WHERE_MENU, fnc = menu),
			PluginDescriptor(name = "EGAMIBoot", description=_('E2 Light Multiboot'), icon='plugin_iconhd.png', where=PluginDescriptor.WHERE_PLUGINMENU, fnc=main)
		]
	else:
		return [
			PluginDescriptor(name = "EGAMIBoot", description = "EGAMI MultiBoot", where = PluginDescriptor.WHERE_MENU, fnc = menu),
			PluginDescriptor(name = "EGAMIBoot", description=_('E2 Light Multiboot'), icon='plugin_icon.png', where=PluginDescriptor.WHERE_PLUGINMENU, fnc=main)
		]