# -*- coding: utf-8 -*-
from __future__ import print_function
from Plugins.Plugin import PluginDescriptor
from enigma import getDesktop
from Screens.Screen import Screen
from Screens.Standby import QUIT_REBOOT, TryQuitMainloop
from Screens.MessageBox import MessageBox
from Components.ActionMap import ActionMap
from Components.MenuList import MenuList
from Components.Label import Label
from Components.ProgressBar import ProgressBar
import os
from skin import parseColor

EGAMIBootImageChoose_Skin = """
	<screen name="EGAMIBootMini" position="center,center" size="960,420" title="EGAMI Multiboot">
	<widget name="label2" position="25,10" size="640,40" zPosition="1" font="Regular;24" valign="center" foregroundColor="#ffffff" backgroundColor="#9f1313" transparent="1"/>
	<widget name="label3" position="25,45" size="640,40" zPosition="1" font="Regular;24" valign="center" foregroundColor="#ffffff" backgroundColor="#9f1313" transparent="1"/>
	<widget name="label4" position="25,80" size="640,40" zPosition="1" font="Regular;24" valign="center" foregroundColor="#ffffff" backgroundColor="#9f1313" transparent="1"/>
	<widget name="label5" position="25,115" size="640,40" zPosition="1" font="Regular;24" valign="center" foregroundColor="#ffffff" backgroundColor="#9f1313" transparent="1"/>
	<widget name="label6" position="510,10" size="430,40" zPosition="1" halign="right" valign="center" font="Regular;24" backgroundColor="#9f1313" foregroundColor="#00389416" transparent="1"/>
	<widget name="label7" position="510,45" size="430,40" zPosition="1" halign="right" valign="center" font="Regular;24" backgroundColor="#9f1313" foregroundColor="#00389416" transparent="1"/>
	<widget name="label8" position="510,80" size="430,40" zPosition="1" halign="right" valign="center" font="Regular;24" backgroundColor="#9f1313" foregroundColor="#00389416" transparent="1"/>
	<widget name="label9" position="510,115" size="430,40" zPosition="1" halign="right" valign="center" font="Regular;24" backgroundColor="#9f1313" foregroundColor="#00389416" transparent="1"/>
	<widget name="label10" position="25,150" size="640,40" zPosition="1" font="Regular;24" valign="center" backgroundColor="#9f1313" transparent="1"/>
	<widget name="label11" position="510,150" size="430,40" zPosition="1" halign="right" valign="center" font="Regular;24" backgroundColor="#9f1313" foregroundColor="#00389416" transparent="1"/>
	<widget name="label1" position="25,190" size="910,40" zPosition="1" foregroundColor="#ffffff" valign="center" halign="center" font="Regular;20" backgroundColor="#9f1313" transparent="1"/>
	<widget name="free_space_progressbar" position="center,60" size="600,15" borderWidth="1" zPosition="3"/>
	<widget name="config" position="25,230" size="910,120" itemHeight="30" valign="center" scrollbarMode="showOnDemand"/>
	<widget name="key_red" position="center,370" size="200,50" font="Regular;24" halign="center" valign="center" backgroundColor="#ff4a3c" foregroundColor="#ffffff" shadowColor="#000000" borderWidth="2" borderColor="#000000" />
	</screen>"""


class EGAMIBootImageChoose(Screen):
	def __init__(self, session):
		self.skin = EGAMIBootImageChoose_Skin
		Screen.__init__(self, session)
		self.list = []
		self.setTitle("EGAMI Boot - Menu")
		self["free_space_progressbar"] = ProgressBar()
		self["linea"] = ProgressBar()
		self["config"] = MenuList(self.list)
		self["key_red"] = Label(_("Boot Image (Ok)"))
		self["label2"] = Label(_("EGAMI Boot is running from:"))
		self["label3"] = Label(_("Used:"))
		self["label4"] = Label(_("Available:"))
		self["label5"] = Label(_("EGAMI Boot is running image:"))
		for label in ["label6", "label7", "label8", "label9", "label11"]:
			self[label] = Label("")
		self["label10"] = Label(_("Number of installed images in EGAMI Boot:"))
		self["label1"] = Label(_("Here is the list of installed images in Your STB. Please choose an image to boot."))
		self["actions"] = ActionMap(["WizardActions", "ColorActions"], {
			"red": self.boot,
			"ok": self.boot,
			"back": self.close})
		self.onShow.append(self.updateList)

	def updateList(self):
		self.list = []
		pluginpath = "/usr/lib/enigma2/python/Plugins/Extensions/EGAMIBoot"
		egamiboot_location_file = os.path.join(pluginpath, ".egamiboot_location")
		mypath = "/media/hdd"
		try:
			with open(egamiboot_location_file, "r") as f:
				mypath = f.readline().strip()
		except Exception as e:
			print("[Egami Boot] Error reading path: %s" % str(e))
		device = "/media/egamiboot"
		dev_free = dev_free_space = def_free_space_percent = ""
		os.system("df > /tmp/ninfo.tmp")

		if os.path.exists("/tmp/ninfo.tmp"):
			with open("/tmp/ninfo.tmp", "r") as f:
				for line in f:
					line = line.replace("part1", " ")
					parts = line.strip().split()
					if parts and parts[-1] == device:
						try:
							dev_free = parts[1]
							dev_free_space = parts[3]
							def_free_space_percent = parts[4]
						except IndexError:
							dev_free = "N/A"
							dev_free_space = parts[2] if len(parts) > 3 else "N/A"
							def_free_space_percent = parts[3] if len(parts) > 4 else "0%"
						break
			os.remove("/tmp/ninfo.tmp")
		try:
			perc = int(def_free_space_percent.strip().rstrip('%'))
		except:
			perc = 0
		self["free_space_progressbar"].setValue(perc)
		colors = {
			"green": "#00389416",
			"yellow": "#00ffe875",
			"orange": "#00ff7f50",
			"red": "#00ff2525"
		}
		if perc < 30:
			color = colors["green"]
		elif perc < 60:
			color = colors["yellow"]
		elif perc < 80:
			color = colors["orange"]
		else:
			color = colors["red"]
		for label in ["label6", "label7", "label8", "label9", "label11"]:
			if self.get(label) and hasattr(self[label], "instance"):
				self[label].instance.setForegroundColor(parseColor(color))
		try:
			with open("/media/egamiboot/EgamiBootI/.egamiboot", "r") as f:
				mypath2 = f.readline().strip()
		except:
			mypath2 = "Flash"

		if mypath2 == "Flash":
			image = os.popen("head -n 1 /etc/hostname").read().split()[0]
			if os.path.exists("/etc/image-version"):
				if "build" not in image:
					with open("/etc/image-version", "r") as f:
						for line in f.readlines():
							if "build=" in line:
								image = image + " build " + line[6:-1]
								with open("/media/egamiboot/EgamiBootI/.Flash", "w") as f:
									f.write(image)
								break
		elif os.path.exists("/media/egamiboot/EgamiBootI/.Flash"):
			with open("/media/egamiboot/EgamiBootI/.Flash", "r") as f:
				image = f.readline().strip()
		image = " [ " + image + " ]"
		self.list.append("Flash" + image)
		self["label6"].setText(mypath)
		self["label7"].setText(def_free_space_percent)
		self["label8"].setText(dev_free_space[0:-3] + " MB")
		self["label9"].setText(mypath2)
		mypath = "/media/egamiboot/EgamiBootI/"
		for fil in os.listdir(mypath):
			if os.path.isdir(os.path.join(mypath, fil)):
				self.list.append(fil)

		self["label11"].setText(str(len(self.list) - 1))
		self["config"].setList(self.list)

	def boot(self):
		self.mysel = self["config"].getCurrent()
		if self.mysel:
			with open("/media/egamiboot/EgamiBootI/.egamiboot", "w") as f:
				f.write(self.mysel)
			os.system("rm /tmp/.egamireboot")
			message = _("Are you sure you want to Boot Image:\n") + self.mysel + " ?"
			ybox = self.session.openWithCallback(self.boot2, MessageBox, message, MessageBox.TYPE_YESNO)
			ybox.setTitle(_("Boot Confirmation"))
		else:
			self.mysel

	def boot2(self, yesno):
		if yesno:
			os.system("touch /tmp/.egamireboot")
			self.session.open(TryQuitMainloop, QUIT_REBOOT)
		else:
			os.system("touch /tmp/.egamireboot")
			self.close()


def remove_egboot():
	search_dir = "/usr/lib/enigma2/python/Plugins/Extensions/EGAMIBoot"
	if os.path.exists(search_dir):
		os.system("rm -rf %s" % search_dir)

remove_egboot()


def main(session, **kwargs):
	try:
		location_file = "/usr/lib/enigma2/python/Plugins/Extensions/EGAMIBoot/.egamiboot_location"
		with open(location_file, "r") as f:
			mypath = f.readline().strip()
		if not os.path.exists("/media/egamiboot"):
			os.mkdir("/media/egamiboot")
		os.system("mount %s /media/egamiboot" % mypath)
		device = None
		with open("/proc/mounts", "r") as f:
			for line in f:
				if "/media/egamiboot" in line:
					device = line.split()[0]
					break
		if device:
			os.system("mount %s %s" % (device, mypath))
			os.system("mount %s /media/egamiboot" % mypath)

	except Exception as e:
		print("[EgamiBoot_mount] Error: %s" % str(e))

	if os.path.exists("/media/egamiboot"):
		if os.path.exists("/media/egamiboot/EgamiBootI/.egamiboot"):
			session.open(EGAMIBootImageChoose)

def menu(menuid, **kwargs):
	if menuid == "mainmenu":
		return [(_("EGAMI Boot"), main, "egami_boot", 1)]
	return []


def Plugins(**kwargs):
	screenwidth = getDesktop(0).size()
	Icon = "plugin_iconhd.png" if screenwidth.width() > 1280 else "plugin_icon.png"
	return [PluginDescriptor(name="EGAMI Boot", description="EGAMI Boot", where=PluginDescriptor.WHERE_MENU, fnc=menu),
			PluginDescriptor(name="EGAMI Boot", description=_("EGAMI Boot"), icon=Icon, where=PluginDescriptor.WHERE_PLUGINMENU, fnc=main)]
